/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.secdnsext.v11;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtDsData;
import com.verisign.epp.codec.secdnsext.v11.EPPSecDNSExtKeyData;
import com.verisign.epp.util.EPPCatFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPSecDNSExtUpdate
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPSecDNSExtUpdate.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private static final long serialVersionUID = -2754621455867222676L;
    public static final int UNSPEC_MAX_SIG_LIFE = -1;
    public static final int MIN_MAX_SIG_LIFE = 0;
    public static final int MAX_MAX_SIG_LIFE = Integer.MAX_VALUE;
    public static final String ELM_NAME = "secDNS:update";
    public static final String ELM_ADD = "secDNS:add";
    public static final String ELM_CHG = "secDNS:chg";
    public static final String ELM_REM = "secDNS:rem";
    public static final String ELM_MAX_SIG_LIFE = "secDNS:maxSigLife";
    private static final String ATTR_URGENT = "urgent";
    private static final String ELM_ALL = "secDNS:all";
    private int maxSigLife = -1;
    private List addDsData = null;
    private List remDsData = null;
    private List addKeyData = null;
    private List remKeyData = null;
    private boolean urgent = false;
    private boolean remAllData = false;

    public String getNamespace() {
        return "urn:ietf:params:xml:ns:secDNS-1.1";
    }

    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            cat.error((Object)("EPPSecDNSExtUpdate.encode(): Invalid state on encode: " + e));
            throw new EPPEncodeException("EPPSecDNSExtUpdate invalid state: " + e);
        }
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null in EPPSecDNSExtUpdate.encode(Document)");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:secDNS-1.1", ELM_NAME);
        root.setAttribute("xmlns:secDNS", "urn:ietf:params:xml:ns:secDNS-1.1");
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "urn:ietf:params:xml:ns:secDNS-1.1 secDNS-1.1.xsd");
        if (this.isRemAllData() || this.hasRemDsData() || this.hasRemKeyData()) {
            Element rem = aDocument.createElementNS("urn:ietf:params:xml:ns:secDNS-1.1", ELM_REM);
            root.appendChild(rem);
            if (this.isRemAllData()) {
                EPPUtil.encodeBoolean(aDocument, rem, new Boolean(this.remAllData), "urn:ietf:params:xml:ns:secDNS-1.1", ELM_ALL);
            } else if (this.hasRemDsData()) {
                EPPUtil.encodeCompList(aDocument, rem, this.remDsData);
            } else {
                EPPUtil.encodeCompList(aDocument, rem, this.remKeyData);
            }
        }
        if (this.hasAddDsData() || this.hasAddKeyData()) {
            Element add = aDocument.createElementNS("urn:ietf:params:xml:ns:secDNS-1.1", ELM_ADD);
            root.appendChild(add);
            if (this.hasAddDsData()) {
                EPPUtil.encodeCompList(aDocument, add, this.addDsData);
            } else {
                EPPUtil.encodeCompList(aDocument, add, this.addKeyData);
            }
        }
        if (this.hasChg()) {
            Element chg = aDocument.createElementNS("urn:ietf:params:xml:ns:secDNS-1.1", ELM_CHG);
            root.appendChild(chg);
            if (this.maxSigLife != -1) {
                EPPUtil.encodeString(aDocument, chg, this.maxSigLife + "", "urn:ietf:params:xml:ns:secDNS-1.1", ELM_MAX_SIG_LIFE);
            }
        }
        if (this.urgent) {
            EPPUtil.encodeBooleanAttr(root, ATTR_URGENT, this.urgent);
        }
        return root;
    }

    public void decode(Element aElement) throws EPPDecodeException {
        this.remAllData = false;
        this.remDsData = null;
        this.remKeyData = null;
        Element remElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:secDNS-1.1", ELM_REM);
        if (remElm != null) {
            Boolean remAll = EPPUtil.decodeBoolean(remElm, "urn:ietf:params:xml:ns:secDNS-1.1", ELM_ALL);
            if (remAll != null && remAll.booleanValue()) {
                this.remAllData = remAll;
            }
            if (remAll == null) {
                this.remDsData = EPPUtil.decodeCompList(remElm, "urn:ietf:params:xml:ns:secDNS-1.1", "secDNS:dsData", EPPSecDNSExtDsData.class);
                if (this.remDsData != null && this.remDsData.isEmpty()) {
                    this.remDsData = null;
                }
            }
            if (this.remDsData == null) {
                this.remKeyData = EPPUtil.decodeCompList(remElm, "urn:ietf:params:xml:ns:secDNS-1.1", "secDNS:keyData", EPPSecDNSExtKeyData.class);
                if (this.remKeyData != null && this.remKeyData.isEmpty()) {
                    this.remKeyData = null;
                }
            }
        }
        this.addDsData = null;
        this.addKeyData = null;
        Element addElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:secDNS-1.1", ELM_ADD);
        if (addElm != null) {
            this.addDsData = EPPUtil.decodeCompList(addElm, "urn:ietf:params:xml:ns:secDNS-1.1", "secDNS:dsData", EPPSecDNSExtDsData.class);
            if (this.addDsData != null && this.addDsData.isEmpty()) {
                this.addDsData = null;
            }
            this.addKeyData = EPPUtil.decodeCompList(addElm, "urn:ietf:params:xml:ns:secDNS-1.1", "secDNS:keyData", EPPSecDNSExtKeyData.class);
            if (this.addKeyData != null && this.addKeyData.isEmpty()) {
                this.addKeyData = null;
            }
        }
        this.maxSigLife = -1;
        Element chgElm = EPPUtil.getElementByTagNameNS(aElement, "urn:ietf:params:xml:ns:secDNS-1.1", ELM_CHG);
        if (chgElm != null) {
            Integer maxSigLifeInt = EPPUtil.decodeInteger(chgElm, "urn:ietf:params:xml:ns:secDNS-1.1", ELM_MAX_SIG_LIFE);
            this.maxSigLife = maxSigLifeInt == null ? -1 : maxSigLifeInt;
        }
        this.urgent = false;
        if (aElement.getAttribute(ATTR_URGENT) != null) {
            this.urgent = EPPUtil.decodeBooleanAttr(aElement, ATTR_URGENT);
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPSecDNSExtUpdate)) {
            return false;
        }
        EPPSecDNSExtUpdate theComp = (EPPSecDNSExtUpdate)aObject;
        if (!EPPUtil.equalLists(this.remDsData, theComp.remDsData)) {
            cat.error((Object)"EPPSecDNSExtUpdate.equals(): remDsData not equal");
            return false;
        }
        if (this.remAllData != theComp.remAllData) {
            return false;
        }
        if (!EPPUtil.equalLists(this.addDsData, theComp.addDsData)) {
            cat.error((Object)"EPPSecDNSExtUpdate.equals(): addDsData not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.remKeyData, theComp.remKeyData)) {
            cat.error((Object)"EPPSecDNSExtUpdate.equals(): remKeyData not equal");
            return false;
        }
        if (!EPPUtil.equalLists(this.addKeyData, theComp.addKeyData)) {
            cat.error((Object)"EPPSecDNSExtUpdate.equals(): addKeyData not equal");
            return false;
        }
        if (this.maxSigLife != theComp.maxSigLife) {
            return false;
        }
        return !this.urgent != theComp.urgent;
    }

    void validateState() throws EPPCodecException {
        if ((this.hasAddDsData() || this.hasRemDsData()) && (this.hasAddKeyData() || this.hasRemKeyData())) {
            throw new EPPCodecException("EPPSecDNSExtUpdate can not have both dsData and keyData set.");
        }
        if (this.isRemAllData() && (this.hasRemKeyData() || this.hasRemDsData())) {
            throw new EPPCodecException("EPPSecDNSExtUpdate can not have both remove all along with remove dsData or keyData.");
        }
        if (!(this.hasAddDsData() || this.hasRemDsData() || this.hasAddKeyData() || this.hasRemKeyData() || this.isRemAllData() || this.hasChg())) {
            throw new EPPCodecException("EPPSecDNSExtUpdate cannot have no adds, removes, or changes.");
        }
    }

    public Object clone() throws CloneNotSupportedException {
        EPPSecDNSExtUpdate clone = null;
        clone = (EPPSecDNSExtUpdate)super.clone();
        clone.remAllData = this.remAllData;
        if (this.remDsData != null) {
            clone.remDsData = new ArrayList(this.remDsData);
        }
        if (this.remKeyData != null) {
            clone.remKeyData = new ArrayList(this.remKeyData);
        }
        if (this.addDsData != null) {
            clone.addDsData = new ArrayList(this.addDsData);
        }
        if (this.addKeyData != null) {
            clone.addKeyData = new ArrayList(this.addKeyData);
        }
        clone.maxSigLife = this.maxSigLife;
        clone.urgent = this.urgent;
        return clone;
    }

    public boolean hasAddDsData() {
        return this.addDsData != null ? !this.addDsData.isEmpty() : false;
    }

    public List getAddDsData() {
        return this.addDsData;
    }

    public void setAddDsData(List aAddDsData) {
        this.addDsData = aAddDsData;
    }

    public void appendAddDsData(EPPSecDNSExtDsData aDsData) {
        if (this.addDsData == null) {
            this.addDsData = new ArrayList();
        }
        this.addDsData.add(aDsData);
    }

    public boolean hasRemDsData() {
        return this.remDsData != null ? !this.remDsData.isEmpty() : false;
    }

    public List getRemDsData() {
        return this.remDsData;
    }

    public void setRemDsData(List aRemDsData) {
        this.remDsData = aRemDsData;
    }

    public void appendRemDsData(EPPSecDNSExtDsData aDsData) {
        if (this.remDsData == null) {
            this.remDsData = new ArrayList();
        }
        this.remDsData.add(aDsData);
    }

    public void setRemAllData(boolean aRemAllData) {
        this.remAllData = aRemAllData;
    }

    public boolean isRemAllData() {
        return this.remAllData;
    }

    public boolean hasAddKeyData() {
        return this.addKeyData != null ? !this.addKeyData.isEmpty() : false;
    }

    public List getAddKeyData() {
        return this.addKeyData;
    }

    public void setAddKeyData(List aAddKeyData) {
        this.addKeyData = aAddKeyData;
    }

    public void appendAddKeyData(EPPSecDNSExtKeyData aKeyData) {
        if (this.addKeyData == null) {
            this.addKeyData = new ArrayList();
        }
        this.addKeyData.add(aKeyData);
    }

    public boolean hasRemKeyData() {
        return this.remKeyData != null ? !this.remKeyData.isEmpty() : false;
    }

    public List getRemKeyData() {
        return this.remKeyData;
    }

    public void setRemKeyData(List aRemKeyData) {
        this.remKeyData = aRemKeyData;
    }

    public void appendRemKeyData(EPPSecDNSExtKeyData aKeyData) {
        if (this.remKeyData == null) {
            this.remKeyData = new ArrayList();
        }
        this.remKeyData.add(aKeyData);
    }

    public boolean isUrgent() {
        return this.urgent;
    }

    public void setUrgent(boolean urgent) {
        this.urgent = urgent;
    }

    public int getMaxSigLife() {
        return this.maxSigLife;
    }

    public void setMaxSigLife(int maxSigLife) {
        this.maxSigLife = maxSigLife;
    }

    public boolean hasMaxSigLife() {
        return this.maxSigLife != -1;
    }

    public boolean hasChg() {
        return this.hasMaxSigLife();
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

