/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.registry;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.registry.EPPRegistryMinMaxPeriod;
import com.verisign.epp.codec.registry.EPPRegistryPeriodType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPRegistryDomainPeriod
implements EPPCodecComponent {
    private static final long serialVersionUID = -7241851592546211256L;
    public static final String ELM_NAME = "registry:period";
    public static final String ELM_SERVER_DECIDED = "registry:serverDecided";
    public static final String ATTR_COMMAND = "command";
    public static final int MAX_PERIOD = 99;
    public static final int MIN_PERIOD = 1;
    private EPPRegistryMinMaxPeriod length = null;
    private Boolean serverDecided = Boolean.FALSE;
    private String command = null;

    public EPPRegistryDomainPeriod() {
    }

    public EPPRegistryDomainPeriod(String command, Integer min, String minUnit, Integer max, String maxUnit, Integer defaultLength, String defaultLengthUnit) {
        this.command = command;
        this.length = new EPPRegistryMinMaxPeriod(min, minUnit, max, maxUnit, defaultLength, defaultLengthUnit);
    }

    public EPPRegistryDomainPeriod(String command, int min, String minUnit, int max, String maxUnit, int defaultLength, String defaultLengthUnit) {
        this.command = command;
        this.length = new EPPRegistryMinMaxPeriod(min, minUnit, max, maxUnit, defaultLength, defaultLengthUnit);
    }

    public EPPRegistryDomainPeriod(String command, Boolean serverDecided) {
        this.command = command;
        this.serverDecided = serverDecided;
    }

    public Element encode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPRegistryDomainPeriod.encode: " + e);
        }
        Element root = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", ELM_NAME);
        root.setAttribute(ATTR_COMMAND, this.command);
        if (this.length != null) {
            EPPUtil.encodeComp(aDocument, root, this.length);
        }
        if (this.serverDecided.booleanValue()) {
            Element child = aDocument.createElementNS("http://www.verisign.com/epp/registry-1.0", ELM_SERVER_DECIDED);
            root.appendChild(child);
        }
        return root;
    }

    public void decode(Element aElement) throws EPPDecodeException {
        this.command = aElement.getAttribute(ATTR_COMMAND);
        Element child = EPPUtil.getElementByTagNameNS(aElement, "http://www.verisign.com/epp/registry-1.0", ELM_SERVER_DECIDED);
        Boolean bl = this.serverDecided = child == null ? Boolean.FALSE : Boolean.TRUE;
        if (Boolean.FALSE == this.serverDecided) {
            this.setLength((EPPRegistryMinMaxPeriod)EPPUtil.decodeComp(aElement, "http://www.verisign.com/epp/registry-1.0", "registry:length", EPPRegistryMinMaxPeriod.class));
        }
    }

    void validateState() throws EPPCodecException {
        if (this.length == null && !this.serverDecided.booleanValue() || this.length != null && this.serverDecided.booleanValue()) {
            throw new EPPCodecException("Either specify length or make it server decided");
        }
        if (this.command == null || this.command.trim().length() == 0) {
            throw new EPPEncodeException("command is required");
        }
        if (this.length != null) {
            this.validPeriod(this.length.getMin(), "min");
            this.validPeriod(this.length.getMax(), "max");
            this.validPeriod(this.length.getDefaultLength(), "default");
            if (this.comparePeriod(this.length.getMin(), this.length.getDefaultLength()) > 0) {
                throw new EPPCodecException("min period cannot be greater than default period");
            }
            if (this.comparePeriod(this.length.getDefaultLength(), this.length.getMax()) > 0) {
                throw new EPPCodecException("default period cannot be greater than max period");
            }
        }
    }

    private void validPeriod(EPPRegistryPeriodType period, String type) throws EPPCodecException {
        if (period == null) {
            throw new EPPCodecException(type + " period is required");
        }
        period.validateState();
    }

    private int comparePeriod(EPPRegistryPeriodType left, EPPRegistryPeriodType right) {
        int l = 0;
        int r = 0;
        if ("y".equals(left.getUnit())) {
            l = left.getNumber() * 12;
        } else if ("m".equals(left.getUnit())) {
            l = left.getNumber();
        }
        if ("y".equals(right.getUnit())) {
            r = right.getNumber() * 12;
        } else if ("m".equals(right.getUnit())) {
            r = right.getNumber();
        }
        return l - r;
    }

    public Object clone() throws CloneNotSupportedException {
        EPPRegistryDomainPeriod clone = (EPPRegistryDomainPeriod)super.clone();
        if (this.length != null) {
            clone.length = (EPPRegistryMinMaxPeriod)this.length.clone();
        }
        return clone;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPRegistryDomainPeriod)) {
            return false;
        }
        EPPRegistryDomainPeriod theComp = (EPPRegistryDomainPeriod)aObject;
        if (!(this.length != null ? this.length.equals(theComp.length) : theComp.length == null)) {
            return false;
        }
        if (!(this.serverDecided != null ? this.serverDecided.equals(theComp.serverDecided) : theComp.serverDecided == null)) {
            return false;
        }
        return this.command != null ? this.command.equals(theComp.command) : theComp.command == null;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public EPPRegistryMinMaxPeriod getLength() {
        return this.length;
    }

    public void setLength(EPPRegistryMinMaxPeriod length) {
        this.length = length;
    }

    public Boolean getServerDecided() {
        return this.serverDecided;
    }

    public void setServerDecided(Boolean serverDecided) {
        this.serverDecided = serverDecided;
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }
}

