/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.nameWatch;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class EPPNameWatchStatus
implements EPPCodecComponent {
    public static final String ELM_STATUS_OK = "ok";
    public static final String ELM_STATUS_SERVER_HOLD = "serverHold";
    public static final String ELM_STATUS_SERVER_RENEW_PROHIBITED = "serverRenewProhibited";
    public static final String ELM_STATUS_SERVER_TRANSFER_PROHIBITED = "serverTransferProhibited";
    public static final String ELM_STATUS_SERVER_UPDATE_PROHIBITED = "serverUpdateProhibited";
    public static final String ELM_STATUS_SERVER_DELETE_PROHIBITED = "serverDeleteProhibited";
    public static final String ELM_STATUS_PENDING_DELETE = "pendingDelete";
    public static final String ELM_STATUS_PENDING_TRANSFER = "pendingTransfer";
    public static final String ELM_STATUS_CLIENT_HOLD = "clientHold";
    public static final String ELM_DEFAULT_LANG = "en";
    public static final String ELM_STATUS_CLIENT_TRANSFER_PROHIBITED = "clientTransferProhibited";
    public static final String ELM_STATUS_CLIENT_UPDATE_PROHIBITED = "clientUpdateProhibited";
    public static final String ELM_STATUS_CLIENT_RENEW_PROHIBITED = "clientRenewProhibited";
    public static final String ELM_STATUS_CLIENT_DELETE_PROHIBITED = "clientDeleteProhibited";
    static final String ELM_NAME = "nameWatch:status";
    static final String ELM_STATUS = "s";
    static final String ELM_LANG = "lang";
    private String status = "ok";
    private String lang = "en";
    private String description = null;

    public EPPNameWatchStatus() {
    }

    public EPPNameWatchStatus(String aStatus) {
        this.status = aStatus;
    }

    public EPPNameWatchStatus(String aStatus, String aDesc) {
        this.status = aStatus;
        this.description = aDesc;
    }

    public EPPNameWatchStatus(String aStatus, String aDesc, String aLang) {
        this.status = aStatus;
        this.description = aDesc;
        this.lang = aLang;
    }

    public Object clone() throws CloneNotSupportedException {
        EPPNameWatchStatus clone = null;
        clone = (EPPNameWatchStatus)super.clone();
        return clone;
    }

    public void decode(Element aElement) throws EPPDecodeException {
        this.status = aElement.getAttribute(ELM_STATUS);
        Node descNode = aElement.getFirstChild();
        if (descNode != null) {
            this.description = descNode.getNodeValue();
            this.lang = aElement.getAttribute(ELM_LANG);
        }
    }

    public Element encode(Document aDocument) throws EPPEncodeException {
        if (this.status == null) {
            throw new EPPEncodeException("required attribute status is not set");
        }
        Element root = aDocument.createElementNS("http://www.nic.name/epp/nameWatch-1.0", ELM_NAME);
        root.setAttribute(ELM_STATUS, this.status);
        if (this.description != null) {
            if (!this.lang.equals(ELM_DEFAULT_LANG)) {
                root.setAttribute(ELM_LANG, this.lang);
            }
            Text descVal = aDocument.createTextNode(this.description);
            root.appendChild(descVal);
        }
        return root;
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPNameWatchStatus)) {
            return false;
        }
        EPPNameWatchStatus theComp = (EPPNameWatchStatus)aObject;
        if (!this.status.equals(theComp.status)) {
            return false;
        }
        if (!(this.description != null ? this.description.equals(theComp.description) : theComp.description == null)) {
            return false;
        }
        return this.lang.equals(theComp.lang);
    }

    public String getLang() {
        return this.lang;
    }

    public String getStatus() {
        return this.status;
    }

    public void setLang(String newLang) {
        this.lang = newLang;
    }

    public void setStatus(String newStatus) {
        this.status = newStatus;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String aDesc) {
        this.description = aDesc;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

