/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.launch;

import com.verisign.epp.codec.gen.EPPCodecComponent;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.util.EPPCatFactory;
import com.verisign.epp.util.EqualityUtil;
import java.util.Date;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPLaunchNotice
implements EPPCodecComponent {
    private static Logger cat = Logger.getLogger((String)EPPLaunchNotice.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    public static final String ELM_LOCALNAME = "notice";
    public static final String ELM_NAME = "launch:notice";
    private static final String ELM_NOTICE_ID = "noticeID";
    private static final String ELM_NOT_AFTER_DATE = "notAfter";
    private static final String ELM_ACCEPTED_DATE = "acceptedDate";
    String noticeId;
    Date notAfterDate;
    Date acceptedDate;

    public EPPLaunchNotice() {
    }

    public EPPLaunchNotice(String aNoticeId, Date aNotAfterDate, Date aAcceptedDate) {
        this.noticeId = aNoticeId;
        this.notAfterDate = aNotAfterDate;
        this.acceptedDate = aAcceptedDate;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        EPPLaunchNotice clone = (EPPLaunchNotice)super.clone();
        return clone;
    }

    @Override
    public Element encode(Document aDocument) throws EPPEncodeException {
        if (aDocument == null) {
            throw new EPPEncodeException("aDocument is null on in EPPLaunchNotice.encode(Document)");
        }
        if (this.noticeId == null) {
            throw new EPPEncodeException("notice identifier is not set.");
        }
        if (this.notAfterDate == null) {
            throw new EPPEncodeException("not after date is not set.");
        }
        if (this.acceptedDate == null) {
            throw new EPPEncodeException("accepted date is not set.");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:launch-1.0", ELM_NAME);
        EPPUtil.encodeString(aDocument, root, this.noticeId, "urn:ietf:params:xml:ns:launch-1.0", "launch:noticeID");
        EPPUtil.encodeTimeInstant(aDocument, root, this.notAfterDate, "urn:ietf:params:xml:ns:launch-1.0", "launch:notAfter");
        EPPUtil.encodeTimeInstant(aDocument, root, this.acceptedDate, "urn:ietf:params:xml:ns:launch-1.0", "launch:acceptedDate");
        return root;
    }

    @Override
    public void decode(Element aElement) throws EPPDecodeException {
        this.noticeId = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:launch-1.0", ELM_NOTICE_ID);
        this.notAfterDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:launch-1.0", ELM_NOT_AFTER_DATE);
        this.acceptedDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:launch-1.0", ELM_ACCEPTED_DATE);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPLaunchNotice)) {
            cat.error((Object)"EPPLaunchNotice.equals(): aObject is not an EPPLaunchNotice");
            return false;
        }
        EPPLaunchNotice other = (EPPLaunchNotice)aObject;
        if (!EqualityUtil.equals(this.noticeId, other.noticeId)) {
            cat.error((Object)"EPPLaunchNotice.equals(): noticeId not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.notAfterDate, other.notAfterDate)) {
            cat.error((Object)"EPPMark.equals(): notAfterDate not equal");
            return false;
        }
        if (!EqualityUtil.equals(this.acceptedDate, other.acceptedDate)) {
            cat.error((Object)"EPPMark.equals(): acceptedDate not equal");
            return false;
        }
        return true;
    }

    public String getNoticeId() {
        return this.noticeId;
    }

    public void setNoticeId(String aNoticeId) {
        this.noticeId = aNoticeId;
    }

    public Date getNotAfterDate() {
        return this.notAfterDate;
    }

    public void setNotAfterDate(Date aNotAfterDate) {
        this.notAfterDate = aNotAfterDate;
    }

    public Date getAcceptedDate() {
        return this.acceptedDate;
    }

    public void setAcceptedDate(Date aAcceptedDate) {
        this.acceptedDate = aAcceptedDate;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }
}

