/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.host;

import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUpdateCmd;
import com.verisign.epp.codec.gen.EPPUtil;
import com.verisign.epp.codec.host.EPPHostAddRemove;
import com.verisign.epp.util.EPPCatFactory;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPHostUpdateCmd
extends EPPUpdateCmd {
    static final String ELM_NAME = "host:update";
    private static final String ELM_HOST_NAME = "host:name";
    private static Logger cat = Logger.getLogger((String)EPPHostUpdateCmd.class.getName(), (LoggerFactory)EPPCatFactory.getInstance().getFactory());
    private String name = null;
    private EPPHostAddRemove add = null;
    private EPPHostAddRemove remove = null;
    private EPPHostAddRemove change = null;

    public EPPHostUpdateCmd() {
    }

    public EPPHostUpdateCmd(String aTransId, String aName) {
        super(aTransId);
        this.name = aName;
    }

    public EPPHostUpdateCmd(String aTransId, String aName, EPPHostAddRemove aAdd, EPPHostAddRemove aRemove, EPPHostAddRemove aChange) {
        super(aTransId);
        this.name = aName;
        this.add = aAdd;
        if (this.add != null) {
            this.add.setMode((short)1);
        }
        this.remove = aRemove;
        if (this.remove != null) {
            this.remove.setMode((short)2);
        }
        this.change = aChange;
        if (this.change != null) {
            this.change.setMode((short)3);
        }
    }

    public String getNamespace() {
        return "urn:ietf:params:xml:ns:host-1.0";
    }

    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        if (this.name == null) {
            throw new EPPEncodeException("required attribute name is not set");
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:host-1.0", ELM_NAME);
        root.setAttribute("xmlns:host", "urn:ietf:params:xml:ns:host-1.0");
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "urn:ietf:params:xml:ns:host-1.0 host-1.0.xsd");
        EPPUtil.encodeString(aDocument, root, this.name, "urn:ietf:params:xml:ns:host-1.0", ELM_HOST_NAME);
        EPPUtil.encodeComp(aDocument, root, this.add);
        EPPUtil.encodeComp(aDocument, root, this.remove);
        EPPUtil.encodeComp(aDocument, root, this.change);
        return root;
    }

    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.name = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:host-1.0", ELM_HOST_NAME);
        this.add = (EPPHostAddRemove)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:host-1.0", "host:add", EPPHostAddRemove.class);
        if (this.add != null) {
            this.add.setMode((short)1);
        }
        this.remove = (EPPHostAddRemove)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:host-1.0", "host:rem", EPPHostAddRemove.class);
        if (this.remove != null) {
            this.remove.setMode((short)2);
        }
        this.change = (EPPHostAddRemove)EPPUtil.decodeComp(aElement, "urn:ietf:params:xml:ns:host-1.0", "host:chg", EPPHostAddRemove.class);
        if (this.change != null) {
            this.change.setMode((short)3);
        }
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPHostUpdateCmd)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPHostUpdateCmd theComp = (EPPHostUpdateCmd)aObject;
        if (!(this.name != null ? this.name.equals(theComp.name) : theComp.name == null)) {
            cat.error((Object)("Name " + this.name + " != " + theComp.name));
            return false;
        }
        if (!(this.add != null ? this.add.equals(theComp.add) : theComp.add == null)) {
            cat.error((Object)("Add " + this.add + " != " + theComp.add));
            return false;
        }
        if (!(this.remove != null ? this.remove.equals(theComp.remove) : theComp.remove == null)) {
            cat.error((Object)("Remove " + this.remove + " != " + theComp.remove));
            return false;
        }
        if (!(this.change != null ? this.change.equals(theComp.change) : theComp.change == null)) {
            cat.error((Object)("Change " + this.change + " != " + theComp.change));
            return false;
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        EPPHostUpdateCmd clone = (EPPHostUpdateCmd)super.clone();
        if (clone.add != null) {
            clone.add = (EPPHostAddRemove)this.add.clone();
        }
        if (clone.remove != null) {
            clone.remove = (EPPHostAddRemove)this.remove.clone();
        }
        if (clone.change != null) {
            clone.change = (EPPHostAddRemove)this.change.clone();
        }
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public EPPHostAddRemove getAdd() {
        return this.add;
    }

    public void setAdd(EPPHostAddRemove aAdd) {
        this.add = aAdd;
        this.add.setMode((short)1);
    }

    public EPPHostAddRemove getRemove() {
        return this.remove;
    }

    public void setRemove(EPPHostAddRemove aRemove) {
        this.remove = aRemove;
        this.remove.setMode((short)2);
    }

    public EPPHostAddRemove getChange() {
        return this.change;
    }

    public void setChange(EPPHostAddRemove newChange) {
        this.change = newChange;
        if (this.change != null) {
            this.change.setMode((short)3);
        }
    }
}

