/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.host;

import com.verisign.epp.codec.gen.EPPCodecException;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPResponse;
import com.verisign.epp.codec.gen.EPPTransId;
import com.verisign.epp.codec.gen.EPPUtil;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EPPHostCreateResp
extends EPPResponse {
    static final String ELM_NAME = "host:creData";
    static final String ELM_HOST_NAME = "host:name";
    static final String ELM_ROID = "host:roid";
    private static final String ELM_CREATION_DATE = "host:crDate";
    private String name = null;
    private Date creationDate = null;

    public EPPHostCreateResp() {
        this.name = null;
    }

    public EPPHostCreateResp(EPPTransId aTransId, String aName) {
        super(aTransId);
        this.name = aName;
    }

    public EPPHostCreateResp(EPPTransId aTransId, String aName, Date aCreationDate) {
        super(aTransId);
        this.name = aName;
        this.creationDate = aCreationDate;
    }

    public String getType() {
        return ELM_NAME;
    }

    public String getNamespace() {
        return "urn:ietf:params:xml:ns:host-1.0";
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date newCrDate) {
        this.creationDate = newCrDate;
    }

    protected Element doEncode(Document aDocument) throws EPPEncodeException {
        try {
            this.validateState();
        }
        catch (EPPCodecException e) {
            throw new EPPEncodeException("Invalid state on EPPHostCreateResp.encode: " + e);
        }
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:host-1.0", ELM_NAME);
        root.setAttribute("xmlns:host", "urn:ietf:params:xml:ns:host-1.0");
        root.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:schemaLocation", "urn:ietf:params:xml:ns:host-1.0 host-1.0.xsd");
        EPPUtil.encodeString(aDocument, root, this.name, "urn:ietf:params:xml:ns:host-1.0", ELM_HOST_NAME);
        EPPUtil.encodeTimeInstant(aDocument, root, this.creationDate, "urn:ietf:params:xml:ns:host-1.0", ELM_CREATION_DATE);
        return root;
    }

    protected void doDecode(Element aElement) throws EPPDecodeException {
        this.name = EPPUtil.decodeString(aElement, "urn:ietf:params:xml:ns:host-1.0", ELM_HOST_NAME);
        this.creationDate = EPPUtil.decodeTimeInstant(aElement, "urn:ietf:params:xml:ns:host-1.0", ELM_CREATION_DATE);
    }

    public boolean equals(Object aObject) {
        if (!(aObject instanceof EPPHostCreateResp)) {
            return false;
        }
        if (!super.equals(aObject)) {
            return false;
        }
        EPPHostCreateResp theCreateData = (EPPHostCreateResp)aObject;
        if (!(this.name != null ? this.name.equals(theCreateData.name) : theCreateData.name == null)) {
            return false;
        }
        return this.creationDate != null ? this.creationDate.equals(theCreateData.creationDate) : theCreateData.creationDate == null;
    }

    public Object clone() throws CloneNotSupportedException {
        EPPHostCreateResp clone = (EPPHostCreateResp)super.clone();
        return clone;
    }

    public String toString() {
        return EPPUtil.toString(this);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    void validateState() throws EPPCodecException {
        if (this.name == null) {
            throw new EPPCodecException("required attribute name is not set");
        }
        if (this.creationDate == null) {
            throw new EPPCodecException("required attribute creationDate is not set");
        }
    }
}

