/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.epp.codec.gen;

import com.verisign.epp.codec.gen.EPPCommand;
import com.verisign.epp.codec.gen.EPPDecodeException;
import com.verisign.epp.codec.gen.EPPEncodeException;
import com.verisign.epp.codec.gen.EPPUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class EPPTransferCmd
extends EPPCommand {
    static final String ELM_NAME = "transfer";
    private static final String ATTR_OP = "op";
    protected String op = null;

    public EPPTransferCmd() {
        this.op = null;
    }

    public EPPTransferCmd(String aTransId, String aOp) {
        super(aTransId);
        this.op = aOp;
    }

    public String getType() {
        return ELM_NAME;
    }

    public String getOp() {
        return this.op;
    }

    public void setOp(String aOp) {
        this.op = aOp;
    }

    public boolean equals(Object aObject) {
        EPPTransferCmd theTransfer = (EPPTransferCmd)aObject;
        if (!super.equals(aObject)) {
            return false;
        }
        return this.op != null ? this.op.equals(theTransfer.op) : theTransfer.op == null;
    }

    protected Element doGenEncode(Document aDocument) throws EPPEncodeException {
        Element root = aDocument.createElementNS("urn:ietf:params:xml:ns:epp-1.0", ELM_NAME);
        if (this.op == null) {
            throw new EPPEncodeException("EPPTransferCmd op attribute is null");
        }
        root.setAttribute(ATTR_OP, this.op);
        Element mapElement = this.doEncode(aDocument);
        if (mapElement != null) {
            root.appendChild(mapElement);
        }
        return root;
    }

    protected void doGenDecode(Element aElement) throws EPPDecodeException {
        this.op = aElement.getAttribute(ATTR_OP);
        if (this.op == null) {
            throw new EPPDecodeException("EPPTransferCmd requires an \"op\" attribute");
        }
        this.doDecode(EPPUtil.getFirstElementChild(aElement));
    }

    public Object clone() throws CloneNotSupportedException {
        EPPTransferCmd clone = null;
        clone = (EPPTransferCmd)super.clone();
        return clone;
    }

    protected abstract Element doEncode(Document var1) throws EPPEncodeException;

    protected abstract void doDecode(Element var1) throws EPPDecodeException;
}

